/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.client;

import com.ibm.hsc.rep.client.RClientObject;
import com.ibm.websm.diagnostics.IDebug;
import java.util.Vector;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;

public class HSCCltObjCache {
    private static final String DEBUG_STRING = "HSCCltObjCache: ";
    private static HSCCltObjCache mInst = null;
    private Vector mObjTable = new Vector();

    public static synchronized HSCCltObjCache getInstance() {
        if (mInst == null) {
            mInst = new HSCCltObjCache();
        }
        return mInst;
    }

    private HSCCltObjCache() {
    }

    public synchronized void addObject(String string) {
        if (-1 == this.mObjTable.indexOf(string)) {
            if (IDebug.enabled()) {
                System.err.println("HSCCltObjCache: add name: " + string);
            }
            this.mObjTable.addElement(string);
        }
    }

    public void addObject(RClientObject rClientObject) {
        String string = this.getObjectName(rClientObject);
        this.addObject(string);
    }

    public void addObject(CIMInstance cIMInstance) {
        String string = this.getObjectName(cIMInstance);
        this.addObject(string);
    }

    public void addObject(CIMObjectPath cIMObjectPath) {
        String string = this.getObjectName(cIMObjectPath);
        this.addObject(string);
    }

    private synchronized void remove(String string) {
        if (this.mObjTable.indexOf(string) != -1) {
            if (IDebug.enabled()) {
                System.err.println("HSCCltObjCache: remove name: " + string);
            }
            this.mObjTable.remove(string);
        }
    }

    public void remove(RClientObject rClientObject) {
        String string = this.getObjectName(rClientObject);
        this.remove(string);
    }

    public void remove(CIMInstance cIMInstance) {
        String string = this.getObjectName(cIMInstance);
        this.remove(string);
    }

    private boolean isCreated(String string) {
        boolean bl;
        boolean bl2 = bl = -1 != this.mObjTable.indexOf(string);
        if (IDebug.enabled()) {
            System.err.println("HSCCltObjCache:  isCreated: " + bl);
        }
        return bl;
    }

    public boolean isCreated(RClientObject rClientObject) {
        String string = this.getObjectName(rClientObject);
        return this.isCreated(string);
    }

    public boolean isCreated(CIMInstance cIMInstance) {
        String string = this.getObjectName(cIMInstance);
        return this.isCreated(string);
    }

    public boolean isParentCreated(RClientObject rClientObject) {
        String string = this.getParentName(rClientObject);
        return this.isCreated(string);
    }

    public boolean isParentCreated(CIMInstance cIMInstance) {
        String string = this.getParentName(cIMInstance);
        return this.isCreated(string);
    }

    private String getObjectName(RClientObject rClientObject) {
        return (String)rClientObject.getProperty("Name");
    }

    private String getObjectName(CIMInstance cIMInstance) {
        return (String)cIMInstance.getProperty("Name").getValue().getValue();
    }

    private String getObjectName(CIMObjectPath cIMObjectPath) {
        Vector vector = cIMObjectPath.getKeys();
        for (int i = 0; i < vector.size(); ++i) {
            CIMProperty cIMProperty = (CIMProperty)vector.elementAt(i);
            String string = cIMProperty.getName();
            if (!string.equals("Name")) continue;
            return (String)cIMProperty.getValue().getValue();
        }
        return null;
    }

    private String getParentName(RClientObject rClientObject) {
        String string = rClientObject.getClassName();
        String string2 = null;
        if (string.equals("IBMHSC_SystemProfile")) {
            string2 = (String)rClientObject.getProperty("SystemName");
        } else if (string.equals("IBMHSC_Partition")) {
            string2 = (String)rClientObject.getProperty("Name");
            string2 = string2.substring(string2.indexOf("*") + 1);
        } else if (string.equals("IBMHSC_LparProfile")) {
            string2 = (String)rClientObject.getProperty("PartitionName");
        }
        if (IDebug.enabled()) {
            System.err.println("className: " + string + "  parent: " + string2);
        }
        return string2;
    }

    private String getParentName(CIMInstance cIMInstance) {
        String string = cIMInstance.getClassName();
        String string2 = null;
        if (string.equals("IBMHSC_SystemProfile")) {
            string2 = (String)cIMInstance.getProperty("SystemName").getValue().getValue();
        } else if (string.equals("IBMHSC_Partition")) {
            string2 = (String)cIMInstance.getProperty("Name").getValue().getValue();
            string2 = string2.substring(string2.indexOf("*") + 1);
        }
        if (string.equals("IBMHSC_LparProfile")) {
            string2 = (String)cIMInstance.getProperty("PartitionName").getValue().getValue();
        }
        if (IDebug.enabled()) {
            System.err.println("className: " + string + "  parent: " + string2);
        }
        return string2;
    }

    public synchronized void cleanup() {
        if (IDebug.enabled()) {
            System.err.println(" Object Cache CLEANUP called ");
        }
        this.mObjTable = new Vector();
    }

    public String toString() {
        Vector vector = this.mObjTable;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < vector.size(); ++i) {
            stringBuffer.append((String)vector.get(i) + "\n");
        }
        return stringBuffer.toString();
    }
}

